/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Drawing;
using System.Globalization;
using System.Collections.Specialized;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.Windows.Forms;

using Borland.Eco.Persistence;
using Borland.Eco.Windows.Forms;
using Borland.Eco.Support;

namespace Borland.Eco.Handles
{
	/// <summary>
	/// Implementor of IConfigureCleanPS, wraps a GUI form
	/// </summary>
	public class FormBasedConfigureCleanPS: IConfigureCleanPS
	{
		private IServiceProvider serviceProvider;
		public FormBasedConfigureCleanPS(IServiceProvider serviceProvider): this()
		{
			this.serviceProvider = serviceProvider;
		}
		public FormBasedConfigureCleanPS()
		{
		}
		private StringCollection m_SystemTables = new StringCollection();
		public void InstallExternalSystemTables(StringCollection tableNames)
		{
			if (tableNames == null) return;
			foreach (string s in tableNames)
				m_SystemTables.Add(s);
		}
		
		private ConfigureCleanPSForm m_CurrentForm;
		public ConfigureCleanPSForm CurrentForm { get { return m_CurrentForm; } }

		///<exception cref="ArgumentNullException">Thrown if <paramref name="SQLtables"/> is null.</exception>
		///<exception cref="InvalidOperationException">Thrown if the user aborts by pressing Cancel in the ensuing dialog.</exception>
		public StringCollection DetermineTablesToDelete(StringCollection allTables, StringCollection knownTables, StringCollection SQLTables)
		{
			if (SQLTables == null) throw new ArgumentNullException("SQLTables"); // Do not localize
			ConfigureCleanPSForm f = new ConfigureCleanPSForm(serviceProvider);
			StringCollection tablesToCreate = new StringCollection();
			foreach (string s in SQLTables)
				if (!tablesToCreate.Contains(s.Trim()))
					tablesToCreate.Add(s.Trim());
			foreach (string s in m_SystemTables)
				if (!tablesToCreate.Contains(s.Trim()))
					tablesToCreate.Add(s.Trim());
			f.AddTableInfo(allTables, knownTables, tablesToCreate);
			try
			{
				m_CurrentForm = f;
				if (f.ShowDialog() == DialogResult.OK)
					return f.TablesToDelete();
				else
					throw new InvalidOperationException(FormsStringRes.sCleaningPSAborted);
			}
			finally
			{
				m_CurrentForm = null;
				f.Dispose();				
			}
		}
	}
	/// <summary>
	/// Summary description for WinForm.
	/// </summary>
	public class ConfigureCleanPSForm: System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.Panel panel1;
		public System.Windows.Forms.Button btnOK;
		public System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.TabControl tabControl1;
		private System.Windows.Forms.TabPage tabPage1;
		private System.Windows.Forms.TabPage tabPage2;
		private System.Windows.Forms.CheckedListBox lbxSelectTables;
		private System.Windows.Forms.ListBox lbxDeleteTables;

		private IServiceProvider serviceProvider;
		private System.Windows.Forms.TabPage tabPage3;
		private System.Windows.Forms.ListBox lbxNewTables;
		private System.Windows.Forms.Label lblNewTables;
		private System.Windows.Forms.Label lblRequiredDrop;
		private System.Windows.Forms.Label lblOptionalDelete;
		private System.Windows.Forms.ContextMenu contextMenu1;
		private System.Windows.Forms.MenuItem mnuSelectAll;
		private System.Windows.Forms.MenuItem mnuUnSelectAll;
		public ConfigureCleanPSForm(IServiceProvider serviceProvider): this()
		{
			this.serviceProvider = serviceProvider;
		}
		public ConfigureCleanPSForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose(bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(ConfigureCleanPSForm));
			this.panel1 = new System.Windows.Forms.Panel();
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnOK = new System.Windows.Forms.Button();
			this.tabControl1 = new System.Windows.Forms.TabControl();
			this.tabPage1 = new System.Windows.Forms.TabPage();
			this.lblOptionalDelete = new System.Windows.Forms.Label();
			this.lbxSelectTables = new System.Windows.Forms.CheckedListBox();
			this.contextMenu1 = new System.Windows.Forms.ContextMenu();
			this.mnuSelectAll = new System.Windows.Forms.MenuItem();
			this.mnuUnSelectAll = new System.Windows.Forms.MenuItem();
			this.tabPage2 = new System.Windows.Forms.TabPage();
			this.lblRequiredDrop = new System.Windows.Forms.Label();
			this.lbxDeleteTables = new System.Windows.Forms.ListBox();
			this.tabPage3 = new System.Windows.Forms.TabPage();
			this.lblNewTables = new System.Windows.Forms.Label();
			this.lbxNewTables = new System.Windows.Forms.ListBox();
			this.panel1.SuspendLayout();
			this.tabControl1.SuspendLayout();
			this.tabPage1.SuspendLayout();
			this.tabPage2.SuspendLayout();
			this.tabPage3.SuspendLayout();
			this.SuspendLayout();
			// 
			// panel1
			// 
			this.panel1.AccessibleDescription = resources.GetString("panel1.AccessibleDescription");
			this.panel1.AccessibleName = resources.GetString("panel1.AccessibleName");
			this.panel1.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("panel1.Anchor")));
			this.panel1.AutoScroll = ((bool)(resources.GetObject("panel1.AutoScroll")));
			this.panel1.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("panel1.AutoScrollMargin")));
			this.panel1.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("panel1.AutoScrollMinSize")));
			this.panel1.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("panel1.BackgroundImage")));
			this.panel1.Controls.Add(this.btnCancel);
			this.panel1.Controls.Add(this.btnOK);
			this.panel1.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("panel1.Dock")));
			this.panel1.Enabled = ((bool)(resources.GetObject("panel1.Enabled")));
			this.panel1.Font = ((System.Drawing.Font)(resources.GetObject("panel1.Font")));
			this.panel1.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("panel1.ImeMode")));
			this.panel1.Location = ((System.Drawing.Point)(resources.GetObject("panel1.Location")));
			this.panel1.Name = "panel1";
			this.panel1.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("panel1.RightToLeft")));
			this.panel1.Size = ((System.Drawing.Size)(resources.GetObject("panel1.Size")));
			this.panel1.TabIndex = ((int)(resources.GetObject("panel1.TabIndex")));
			this.panel1.Text = resources.GetString("panel1.Text");
			this.panel1.Visible = ((bool)(resources.GetObject("panel1.Visible")));
			// 
			// btnCancel
			// 
			this.btnCancel.AccessibleDescription = resources.GetString("btnCancel.AccessibleDescription");
			this.btnCancel.AccessibleName = resources.GetString("btnCancel.AccessibleName");
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnCancel.Anchor")));
			this.btnCancel.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnCancel.BackgroundImage")));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnCancel.Dock")));
			this.btnCancel.Enabled = ((bool)(resources.GetObject("btnCancel.Enabled")));
			this.btnCancel.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnCancel.FlatStyle")));
			this.btnCancel.Font = ((System.Drawing.Font)(resources.GetObject("btnCancel.Font")));
			this.btnCancel.Image = ((System.Drawing.Image)(resources.GetObject("btnCancel.Image")));
			this.btnCancel.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnCancel.ImageAlign")));
			this.btnCancel.ImageIndex = ((int)(resources.GetObject("btnCancel.ImageIndex")));
			this.btnCancel.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnCancel.ImeMode")));
			this.btnCancel.Location = ((System.Drawing.Point)(resources.GetObject("btnCancel.Location")));
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnCancel.RightToLeft")));
			this.btnCancel.Size = ((System.Drawing.Size)(resources.GetObject("btnCancel.Size")));
			this.btnCancel.TabIndex = ((int)(resources.GetObject("btnCancel.TabIndex")));
			this.btnCancel.Text = resources.GetString("btnCancel.Text");
			this.btnCancel.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnCancel.TextAlign")));
			this.btnCancel.Visible = ((bool)(resources.GetObject("btnCancel.Visible")));
			// 
			// btnOK
			// 
			this.btnOK.AccessibleDescription = resources.GetString("btnOK.AccessibleDescription");
			this.btnOK.AccessibleName = resources.GetString("btnOK.AccessibleName");
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnOK.Anchor")));
			this.btnOK.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnOK.BackgroundImage")));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnOK.Dock")));
			this.btnOK.Enabled = ((bool)(resources.GetObject("btnOK.Enabled")));
			this.btnOK.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnOK.FlatStyle")));
			this.btnOK.Font = ((System.Drawing.Font)(resources.GetObject("btnOK.Font")));
			this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
			this.btnOK.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnOK.ImageAlign")));
			this.btnOK.ImageIndex = ((int)(resources.GetObject("btnOK.ImageIndex")));
			this.btnOK.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnOK.ImeMode")));
			this.btnOK.Location = ((System.Drawing.Point)(resources.GetObject("btnOK.Location")));
			this.btnOK.Name = "btnOK";
			this.btnOK.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnOK.RightToLeft")));
			this.btnOK.Size = ((System.Drawing.Size)(resources.GetObject("btnOK.Size")));
			this.btnOK.TabIndex = ((int)(resources.GetObject("btnOK.TabIndex")));
			this.btnOK.Text = resources.GetString("btnOK.Text");
			this.btnOK.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnOK.TextAlign")));
			this.btnOK.Visible = ((bool)(resources.GetObject("btnOK.Visible")));
			// 
			// tabControl1
			// 
			this.tabControl1.AccessibleDescription = resources.GetString("tabControl1.AccessibleDescription");
			this.tabControl1.AccessibleName = resources.GetString("tabControl1.AccessibleName");
			this.tabControl1.Alignment = ((System.Windows.Forms.TabAlignment)(resources.GetObject("tabControl1.Alignment")));
			this.tabControl1.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("tabControl1.Anchor")));
			this.tabControl1.Appearance = ((System.Windows.Forms.TabAppearance)(resources.GetObject("tabControl1.Appearance")));
			this.tabControl1.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("tabControl1.BackgroundImage")));
			this.tabControl1.Controls.Add(this.tabPage1);
			this.tabControl1.Controls.Add(this.tabPage2);
			this.tabControl1.Controls.Add(this.tabPage3);
			this.tabControl1.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("tabControl1.Dock")));
			this.tabControl1.Enabled = ((bool)(resources.GetObject("tabControl1.Enabled")));
			this.tabControl1.Font = ((System.Drawing.Font)(resources.GetObject("tabControl1.Font")));
			this.tabControl1.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("tabControl1.ImeMode")));
			this.tabControl1.ItemSize = ((System.Drawing.Size)(resources.GetObject("tabControl1.ItemSize")));
			this.tabControl1.Location = ((System.Drawing.Point)(resources.GetObject("tabControl1.Location")));
			this.tabControl1.Name = "tabControl1";
			this.tabControl1.Padding = ((System.Drawing.Point)(resources.GetObject("tabControl1.Padding")));
			this.tabControl1.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("tabControl1.RightToLeft")));
			this.tabControl1.SelectedIndex = 0;
			this.tabControl1.ShowToolTips = ((bool)(resources.GetObject("tabControl1.ShowToolTips")));
			this.tabControl1.Size = ((System.Drawing.Size)(resources.GetObject("tabControl1.Size")));
			this.tabControl1.TabIndex = ((int)(resources.GetObject("tabControl1.TabIndex")));
			this.tabControl1.Text = resources.GetString("tabControl1.Text");
			this.tabControl1.Visible = ((bool)(resources.GetObject("tabControl1.Visible")));
			// 
			// tabPage1
			// 
			this.tabPage1.AccessibleDescription = resources.GetString("tabPage1.AccessibleDescription");
			this.tabPage1.AccessibleName = resources.GetString("tabPage1.AccessibleName");
			this.tabPage1.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("tabPage1.Anchor")));
			this.tabPage1.AutoScroll = ((bool)(resources.GetObject("tabPage1.AutoScroll")));
			this.tabPage1.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("tabPage1.AutoScrollMargin")));
			this.tabPage1.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("tabPage1.AutoScrollMinSize")));
			this.tabPage1.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("tabPage1.BackgroundImage")));
			this.tabPage1.Controls.Add(this.lblOptionalDelete);
			this.tabPage1.Controls.Add(this.lbxSelectTables);
			this.tabPage1.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("tabPage1.Dock")));
			this.tabPage1.Enabled = ((bool)(resources.GetObject("tabPage1.Enabled")));
			this.tabPage1.Font = ((System.Drawing.Font)(resources.GetObject("tabPage1.Font")));
			this.tabPage1.ImageIndex = ((int)(resources.GetObject("tabPage1.ImageIndex")));
			this.tabPage1.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("tabPage1.ImeMode")));
			this.tabPage1.Location = ((System.Drawing.Point)(resources.GetObject("tabPage1.Location")));
			this.tabPage1.Name = "tabPage1";
			this.tabPage1.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("tabPage1.RightToLeft")));
			this.tabPage1.Size = ((System.Drawing.Size)(resources.GetObject("tabPage1.Size")));
			this.tabPage1.TabIndex = ((int)(resources.GetObject("tabPage1.TabIndex")));
			this.tabPage1.Text = resources.GetString("tabPage1.Text");
			this.tabPage1.ToolTipText = resources.GetString("tabPage1.ToolTipText");
			this.tabPage1.Visible = ((bool)(resources.GetObject("tabPage1.Visible")));
			// 
			// lblOptionalDelete
			// 
			this.lblOptionalDelete.AccessibleDescription = resources.GetString("lblOptionalDelete.AccessibleDescription");
			this.lblOptionalDelete.AccessibleName = resources.GetString("lblOptionalDelete.AccessibleName");
			this.lblOptionalDelete.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("lblOptionalDelete.Anchor")));
			this.lblOptionalDelete.AutoSize = ((bool)(resources.GetObject("lblOptionalDelete.AutoSize")));
			this.lblOptionalDelete.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("lblOptionalDelete.Dock")));
			this.lblOptionalDelete.Enabled = ((bool)(resources.GetObject("lblOptionalDelete.Enabled")));
			this.lblOptionalDelete.Font = ((System.Drawing.Font)(resources.GetObject("lblOptionalDelete.Font")));
			this.lblOptionalDelete.Image = ((System.Drawing.Image)(resources.GetObject("lblOptionalDelete.Image")));
			this.lblOptionalDelete.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("lblOptionalDelete.ImageAlign")));
			this.lblOptionalDelete.ImageIndex = ((int)(resources.GetObject("lblOptionalDelete.ImageIndex")));
			this.lblOptionalDelete.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("lblOptionalDelete.ImeMode")));
			this.lblOptionalDelete.Location = ((System.Drawing.Point)(resources.GetObject("lblOptionalDelete.Location")));
			this.lblOptionalDelete.Name = "lblOptionalDelete";
			this.lblOptionalDelete.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("lblOptionalDelete.RightToLeft")));
			this.lblOptionalDelete.Size = ((System.Drawing.Size)(resources.GetObject("lblOptionalDelete.Size")));
			this.lblOptionalDelete.TabIndex = ((int)(resources.GetObject("lblOptionalDelete.TabIndex")));
			this.lblOptionalDelete.Text = resources.GetString("lblOptionalDelete.Text");
			this.lblOptionalDelete.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("lblOptionalDelete.TextAlign")));
			this.lblOptionalDelete.Visible = ((bool)(resources.GetObject("lblOptionalDelete.Visible")));
			// 
			// lbxSelectTables
			// 
			this.lbxSelectTables.AccessibleDescription = resources.GetString("lbxSelectTables.AccessibleDescription");
			this.lbxSelectTables.AccessibleName = resources.GetString("lbxSelectTables.AccessibleName");
			this.lbxSelectTables.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("lbxSelectTables.Anchor")));
			this.lbxSelectTables.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("lbxSelectTables.BackgroundImage")));
			this.lbxSelectTables.CheckOnClick = true;
			this.lbxSelectTables.ColumnWidth = ((int)(resources.GetObject("lbxSelectTables.ColumnWidth")));
			this.lbxSelectTables.ContextMenu = this.contextMenu1;
			this.lbxSelectTables.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("lbxSelectTables.Dock")));
			this.lbxSelectTables.Enabled = ((bool)(resources.GetObject("lbxSelectTables.Enabled")));
			this.lbxSelectTables.Font = ((System.Drawing.Font)(resources.GetObject("lbxSelectTables.Font")));
			this.lbxSelectTables.HorizontalExtent = ((int)(resources.GetObject("lbxSelectTables.HorizontalExtent")));
			this.lbxSelectTables.HorizontalScrollbar = ((bool)(resources.GetObject("lbxSelectTables.HorizontalScrollbar")));
			this.lbxSelectTables.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("lbxSelectTables.ImeMode")));
			this.lbxSelectTables.IntegralHeight = ((bool)(resources.GetObject("lbxSelectTables.IntegralHeight")));
			this.lbxSelectTables.Location = ((System.Drawing.Point)(resources.GetObject("lbxSelectTables.Location")));
			this.lbxSelectTables.Name = "lbxSelectTables";
			this.lbxSelectTables.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("lbxSelectTables.RightToLeft")));
			this.lbxSelectTables.ScrollAlwaysVisible = ((bool)(resources.GetObject("lbxSelectTables.ScrollAlwaysVisible")));
			this.lbxSelectTables.Size = ((System.Drawing.Size)(resources.GetObject("lbxSelectTables.Size")));
			this.lbxSelectTables.TabIndex = ((int)(resources.GetObject("lbxSelectTables.TabIndex")));
			this.lbxSelectTables.Visible = ((bool)(resources.GetObject("lbxSelectTables.Visible")));
			// 
			// contextMenu1
			// 
			this.contextMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.mnuSelectAll,
						this.mnuUnSelectAll});
			this.contextMenu1.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("contextMenu1.RightToLeft")));
			// 
			// mnuSelectAll
			// 
			this.mnuSelectAll.Enabled = ((bool)(resources.GetObject("mnuSelectAll.Enabled")));
			this.mnuSelectAll.Index = 0;
			this.mnuSelectAll.Shortcut = ((System.Windows.Forms.Shortcut)(resources.GetObject("mnuSelectAll.Shortcut")));
			this.mnuSelectAll.ShowShortcut = ((bool)(resources.GetObject("mnuSelectAll.ShowShortcut")));
			this.mnuSelectAll.Text = resources.GetString("mnuSelectAll.Text");
			this.mnuSelectAll.Visible = ((bool)(resources.GetObject("mnuSelectAll.Visible")));
			this.mnuSelectAll.Click += new System.EventHandler(this.mnuSelectAll_Click);
			// 
			// mnuUnSelectAll
			// 
			this.mnuUnSelectAll.Enabled = ((bool)(resources.GetObject("mnuUnSelectAll.Enabled")));
			this.mnuUnSelectAll.Index = 1;
			this.mnuUnSelectAll.Shortcut = ((System.Windows.Forms.Shortcut)(resources.GetObject("mnuUnSelectAll.Shortcut")));
			this.mnuUnSelectAll.ShowShortcut = ((bool)(resources.GetObject("mnuUnSelectAll.ShowShortcut")));
			this.mnuUnSelectAll.Text = resources.GetString("mnuUnSelectAll.Text");
			this.mnuUnSelectAll.Visible = ((bool)(resources.GetObject("mnuUnSelectAll.Visible")));
			this.mnuUnSelectAll.Click += new System.EventHandler(this.mnuUnselectAll_Click);
			// 
			// tabPage2
			// 
			this.tabPage2.AccessibleDescription = resources.GetString("tabPage2.AccessibleDescription");
			this.tabPage2.AccessibleName = resources.GetString("tabPage2.AccessibleName");
			this.tabPage2.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("tabPage2.Anchor")));
			this.tabPage2.AutoScroll = ((bool)(resources.GetObject("tabPage2.AutoScroll")));
			this.tabPage2.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("tabPage2.AutoScrollMargin")));
			this.tabPage2.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("tabPage2.AutoScrollMinSize")));
			this.tabPage2.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("tabPage2.BackgroundImage")));
			this.tabPage2.Controls.Add(this.lblRequiredDrop);
			this.tabPage2.Controls.Add(this.lbxDeleteTables);
			this.tabPage2.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("tabPage2.Dock")));
			this.tabPage2.Enabled = ((bool)(resources.GetObject("tabPage2.Enabled")));
			this.tabPage2.Font = ((System.Drawing.Font)(resources.GetObject("tabPage2.Font")));
			this.tabPage2.ImageIndex = ((int)(resources.GetObject("tabPage2.ImageIndex")));
			this.tabPage2.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("tabPage2.ImeMode")));
			this.tabPage2.Location = ((System.Drawing.Point)(resources.GetObject("tabPage2.Location")));
			this.tabPage2.Name = "tabPage2";
			this.tabPage2.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("tabPage2.RightToLeft")));
			this.tabPage2.Size = ((System.Drawing.Size)(resources.GetObject("tabPage2.Size")));
			this.tabPage2.TabIndex = ((int)(resources.GetObject("tabPage2.TabIndex")));
			this.tabPage2.Text = resources.GetString("tabPage2.Text");
			this.tabPage2.ToolTipText = resources.GetString("tabPage2.ToolTipText");
			this.tabPage2.Visible = ((bool)(resources.GetObject("tabPage2.Visible")));
			// 
			// lblRequiredDrop
			// 
			this.lblRequiredDrop.AccessibleDescription = resources.GetString("lblRequiredDrop.AccessibleDescription");
			this.lblRequiredDrop.AccessibleName = resources.GetString("lblRequiredDrop.AccessibleName");
			this.lblRequiredDrop.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("lblRequiredDrop.Anchor")));
			this.lblRequiredDrop.AutoSize = ((bool)(resources.GetObject("lblRequiredDrop.AutoSize")));
			this.lblRequiredDrop.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("lblRequiredDrop.Dock")));
			this.lblRequiredDrop.Enabled = ((bool)(resources.GetObject("lblRequiredDrop.Enabled")));
			this.lblRequiredDrop.Font = ((System.Drawing.Font)(resources.GetObject("lblRequiredDrop.Font")));
			this.lblRequiredDrop.Image = ((System.Drawing.Image)(resources.GetObject("lblRequiredDrop.Image")));
			this.lblRequiredDrop.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("lblRequiredDrop.ImageAlign")));
			this.lblRequiredDrop.ImageIndex = ((int)(resources.GetObject("lblRequiredDrop.ImageIndex")));
			this.lblRequiredDrop.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("lblRequiredDrop.ImeMode")));
			this.lblRequiredDrop.Location = ((System.Drawing.Point)(resources.GetObject("lblRequiredDrop.Location")));
			this.lblRequiredDrop.Name = "lblRequiredDrop";
			this.lblRequiredDrop.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("lblRequiredDrop.RightToLeft")));
			this.lblRequiredDrop.Size = ((System.Drawing.Size)(resources.GetObject("lblRequiredDrop.Size")));
			this.lblRequiredDrop.TabIndex = ((int)(resources.GetObject("lblRequiredDrop.TabIndex")));
			this.lblRequiredDrop.Text = resources.GetString("lblRequiredDrop.Text");
			this.lblRequiredDrop.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("lblRequiredDrop.TextAlign")));
			this.lblRequiredDrop.Visible = ((bool)(resources.GetObject("lblRequiredDrop.Visible")));
			// 
			// lbxDeleteTables
			// 
			this.lbxDeleteTables.AccessibleDescription = resources.GetString("lbxDeleteTables.AccessibleDescription");
			this.lbxDeleteTables.AccessibleName = resources.GetString("lbxDeleteTables.AccessibleName");
			this.lbxDeleteTables.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("lbxDeleteTables.Anchor")));
			this.lbxDeleteTables.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("lbxDeleteTables.BackgroundImage")));
			this.lbxDeleteTables.ColumnWidth = ((int)(resources.GetObject("lbxDeleteTables.ColumnWidth")));
			this.lbxDeleteTables.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("lbxDeleteTables.Dock")));
			this.lbxDeleteTables.Enabled = ((bool)(resources.GetObject("lbxDeleteTables.Enabled")));
			this.lbxDeleteTables.Font = ((System.Drawing.Font)(resources.GetObject("lbxDeleteTables.Font")));
			this.lbxDeleteTables.HorizontalExtent = ((int)(resources.GetObject("lbxDeleteTables.HorizontalExtent")));
			this.lbxDeleteTables.HorizontalScrollbar = ((bool)(resources.GetObject("lbxDeleteTables.HorizontalScrollbar")));
			this.lbxDeleteTables.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("lbxDeleteTables.ImeMode")));
			this.lbxDeleteTables.IntegralHeight = ((bool)(resources.GetObject("lbxDeleteTables.IntegralHeight")));
			this.lbxDeleteTables.ItemHeight = ((int)(resources.GetObject("lbxDeleteTables.ItemHeight")));
			this.lbxDeleteTables.Location = ((System.Drawing.Point)(resources.GetObject("lbxDeleteTables.Location")));
			this.lbxDeleteTables.Name = "lbxDeleteTables";
			this.lbxDeleteTables.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("lbxDeleteTables.RightToLeft")));
			this.lbxDeleteTables.ScrollAlwaysVisible = ((bool)(resources.GetObject("lbxDeleteTables.ScrollAlwaysVisible")));
			this.lbxDeleteTables.Size = ((System.Drawing.Size)(resources.GetObject("lbxDeleteTables.Size")));
			this.lbxDeleteTables.TabIndex = ((int)(resources.GetObject("lbxDeleteTables.TabIndex")));
			this.lbxDeleteTables.Visible = ((bool)(resources.GetObject("lbxDeleteTables.Visible")));
			// 
			// tabPage3
			// 
			this.tabPage3.AccessibleDescription = resources.GetString("tabPage3.AccessibleDescription");
			this.tabPage3.AccessibleName = resources.GetString("tabPage3.AccessibleName");
			this.tabPage3.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("tabPage3.Anchor")));
			this.tabPage3.AutoScroll = ((bool)(resources.GetObject("tabPage3.AutoScroll")));
			this.tabPage3.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("tabPage3.AutoScrollMargin")));
			this.tabPage3.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("tabPage3.AutoScrollMinSize")));
			this.tabPage3.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("tabPage3.BackgroundImage")));
			this.tabPage3.Controls.Add(this.lblNewTables);
			this.tabPage3.Controls.Add(this.lbxNewTables);
			this.tabPage3.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("tabPage3.Dock")));
			this.tabPage3.Enabled = ((bool)(resources.GetObject("tabPage3.Enabled")));
			this.tabPage3.Font = ((System.Drawing.Font)(resources.GetObject("tabPage3.Font")));
			this.tabPage3.ImageIndex = ((int)(resources.GetObject("tabPage3.ImageIndex")));
			this.tabPage3.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("tabPage3.ImeMode")));
			this.tabPage3.Location = ((System.Drawing.Point)(resources.GetObject("tabPage3.Location")));
			this.tabPage3.Name = "tabPage3";
			this.tabPage3.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("tabPage3.RightToLeft")));
			this.tabPage3.Size = ((System.Drawing.Size)(resources.GetObject("tabPage3.Size")));
			this.tabPage3.TabIndex = ((int)(resources.GetObject("tabPage3.TabIndex")));
			this.tabPage3.Text = resources.GetString("tabPage3.Text");
			this.tabPage3.ToolTipText = resources.GetString("tabPage3.ToolTipText");
			this.tabPage3.Visible = ((bool)(resources.GetObject("tabPage3.Visible")));
			// 
			// lblNewTables
			// 
			this.lblNewTables.AccessibleDescription = resources.GetString("lblNewTables.AccessibleDescription");
			this.lblNewTables.AccessibleName = resources.GetString("lblNewTables.AccessibleName");
			this.lblNewTables.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("lblNewTables.Anchor")));
			this.lblNewTables.AutoSize = ((bool)(resources.GetObject("lblNewTables.AutoSize")));
			this.lblNewTables.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("lblNewTables.Dock")));
			this.lblNewTables.Enabled = ((bool)(resources.GetObject("lblNewTables.Enabled")));
			this.lblNewTables.Font = ((System.Drawing.Font)(resources.GetObject("lblNewTables.Font")));
			this.lblNewTables.Image = ((System.Drawing.Image)(resources.GetObject("lblNewTables.Image")));
			this.lblNewTables.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("lblNewTables.ImageAlign")));
			this.lblNewTables.ImageIndex = ((int)(resources.GetObject("lblNewTables.ImageIndex")));
			this.lblNewTables.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("lblNewTables.ImeMode")));
			this.lblNewTables.Location = ((System.Drawing.Point)(resources.GetObject("lblNewTables.Location")));
			this.lblNewTables.Name = "lblNewTables";
			this.lblNewTables.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("lblNewTables.RightToLeft")));
			this.lblNewTables.Size = ((System.Drawing.Size)(resources.GetObject("lblNewTables.Size")));
			this.lblNewTables.TabIndex = ((int)(resources.GetObject("lblNewTables.TabIndex")));
			this.lblNewTables.Text = resources.GetString("lblNewTables.Text");
			this.lblNewTables.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("lblNewTables.TextAlign")));
			this.lblNewTables.Visible = ((bool)(resources.GetObject("lblNewTables.Visible")));
			// 
			// lbxNewTables
			// 
			this.lbxNewTables.AccessibleDescription = resources.GetString("lbxNewTables.AccessibleDescription");
			this.lbxNewTables.AccessibleName = resources.GetString("lbxNewTables.AccessibleName");
			this.lbxNewTables.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("lbxNewTables.Anchor")));
			this.lbxNewTables.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("lbxNewTables.BackgroundImage")));
			this.lbxNewTables.ColumnWidth = ((int)(resources.GetObject("lbxNewTables.ColumnWidth")));
			this.lbxNewTables.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("lbxNewTables.Dock")));
			this.lbxNewTables.Enabled = ((bool)(resources.GetObject("lbxNewTables.Enabled")));
			this.lbxNewTables.Font = ((System.Drawing.Font)(resources.GetObject("lbxNewTables.Font")));
			this.lbxNewTables.HorizontalExtent = ((int)(resources.GetObject("lbxNewTables.HorizontalExtent")));
			this.lbxNewTables.HorizontalScrollbar = ((bool)(resources.GetObject("lbxNewTables.HorizontalScrollbar")));
			this.lbxNewTables.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("lbxNewTables.ImeMode")));
			this.lbxNewTables.IntegralHeight = ((bool)(resources.GetObject("lbxNewTables.IntegralHeight")));
			this.lbxNewTables.ItemHeight = ((int)(resources.GetObject("lbxNewTables.ItemHeight")));
			this.lbxNewTables.Location = ((System.Drawing.Point)(resources.GetObject("lbxNewTables.Location")));
			this.lbxNewTables.Name = "lbxNewTables";
			this.lbxNewTables.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("lbxNewTables.RightToLeft")));
			this.lbxNewTables.ScrollAlwaysVisible = ((bool)(resources.GetObject("lbxNewTables.ScrollAlwaysVisible")));
			this.lbxNewTables.Size = ((System.Drawing.Size)(resources.GetObject("lbxNewTables.Size")));
			this.lbxNewTables.TabIndex = ((int)(resources.GetObject("lbxNewTables.TabIndex")));
			this.lbxNewTables.Visible = ((bool)(resources.GetObject("lbxNewTables.Visible")));
			// 
			// ConfigureCleanPSForm
			// 
			this.AcceptButton = this.btnOK;
			this.AccessibleDescription = resources.GetString("$this.AccessibleDescription");
			this.AccessibleName = resources.GetString("$this.AccessibleName");
			this.AutoScaleBaseSize = ((System.Drawing.Size)(resources.GetObject("$this.AutoScaleBaseSize")));
			this.AutoScroll = ((bool)(resources.GetObject("$this.AutoScroll")));
			this.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMargin")));
			this.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMinSize")));
			this.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("$this.BackgroundImage")));
			this.CancelButton = this.btnCancel;
			this.ClientSize = ((System.Drawing.Size)(resources.GetObject("$this.ClientSize")));
			this.Controls.Add(this.tabControl1);
			this.Controls.Add(this.panel1);
			this.Enabled = ((bool)(resources.GetObject("$this.Enabled")));
			this.Font = ((System.Drawing.Font)(resources.GetObject("$this.Font")));
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("$this.ImeMode")));
			this.Location = ((System.Drawing.Point)(resources.GetObject("$this.Location")));
			this.MaximizeBox = false;
			this.MaximumSize = ((System.Drawing.Size)(resources.GetObject("$this.MaximumSize")));
			this.MinimizeBox = false;
			this.MinimumSize = ((System.Drawing.Size)(resources.GetObject("$this.MinimumSize")));
			this.Name = "ConfigureCleanPSForm";
			this.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("$this.RightToLeft")));
			this.StartPosition = ((System.Windows.Forms.FormStartPosition)(resources.GetObject("$this.StartPosition")));
			this.Text = resources.GetString("$this.Text");
			this.HelpRequested += new System.Windows.Forms.HelpEventHandler(this.ConfigureCleanPSForm_HelpRequested);
			this.panel1.ResumeLayout(false);
			this.tabControl1.ResumeLayout(false);
			this.tabPage1.ResumeLayout(false);
			this.tabPage2.ResumeLayout(false);
			this.tabPage3.ResumeLayout(false);
			this.ResumeLayout(false);
		}
		#endregion

		private static void StringCollectionToUpper(StringCollection strCollection)
		{
			if (strCollection != null)
			{
				for (int i = 0; i < strCollection.Count; i++)
					if (strCollection[i] != null)
						strCollection[i] = strCollection[i].ToUpper(CultureInfo.InvariantCulture);
			}
		}

		public void AddTableInfo(StringCollection allTables, StringCollection knownTables, StringCollection sqlTables)
		{
			// allTables = all tables found in DB
			// knownTables = all tables found in ECO list of tables in DB
			// sqlTables = all tables that need to be created

			// Databases do not guarantee case of returned values.
			// Better make it all uppercase, as .Contains() is case sensitive.
			StringCollectionToUpper(allTables);
			StringCollectionToUpper(knownTables);
			StringCollectionToUpper(sqlTables);

			foreach (String tableName in sqlTables)
			{
				// delete all tables that already exist, and the rest is marked as new
				if (allTables.Contains(tableName))
					lbxDeleteTables.Items.Add(tableName);
				else
					lbxNewTables.Items.Add(tableName);
			}

			foreach (String tableName in allTables)
			{
				if (!sqlTables.Contains(tableName))
				{
					if (knownTables.Contains(tableName))
					{
						lbxSelectTables.Items.Add(tableName);
						lbxSelectTables.SetItemChecked(lbxSelectTables.Items.Count-1, true);
					}
					else
						lbxSelectTables.Items.Add(tableName);
				}
			}

			tabPage1.Text += " (" + lbxSelectTables.Items.Count.ToString(CultureInfo.InvariantCulture) + ")";
			tabPage2.Text += " (" + lbxDeleteTables.Items.Count.ToString(CultureInfo.InvariantCulture) + ")";
			tabPage3.Text += " (" + lbxNewTables.Items.Count.ToString(CultureInfo.InvariantCulture) + ")";

			if (lbxSelectTables.Items.Count == 0)
			{
				tabControl1.SelectedTab = tabPage2;
				lbxSelectTables.Items.Add(FormsStringRes.sNoTablesToSelectFrom);
				lbxSelectTables.Enabled = false;
			}
			lbxNewTables.Sorted = true;
			lbxDeleteTables.Sorted = true;
			lbxSelectTables.Sorted = true;
		}
		public StringCollection TablesToDelete()
		{
			StringCollection Result = new StringCollection();
			foreach (String tableName in lbxDeleteTables.Items)
				Result.Add(tableName);
			foreach (String tableName in lbxSelectTables.CheckedItems)
				Result.Add(tableName);
			return Result;
		}

		private void ConfigureCleanPSForm_HelpRequested(object sender, System.Windows.Forms.HelpEventArgs hlpevent)
		{
			if (serviceProvider == null) return;

			IHelpService helpService = (IHelpService)serviceProvider.GetService(typeof(IHelpService));
			if (helpService != null)
				helpService.ShowHelpFromKeyword(HelpHelpers.hcEcoConfigureCleanPSForm);
		}
		
		private void mnuSelectAll_Click(object sender, System.EventArgs e)
		{
			for (int i=0; i<lbxSelectTables.Items.Count; i++)
				lbxSelectTables.SetItemChecked(i, true);
		}

		private void mnuUnselectAll_Click(object sender, System.EventArgs e)
		{
			for (int i=0; i<lbxSelectTables.Items.Count; i++)
				lbxSelectTables.SetItemChecked(i, false);
		}
	}
}
